/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.nakedos;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.nakedos.NakedosFileEntry;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.ArrayList;
import java.util.List;

public class NakedosFormatDisk
extends FormattedDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int TRACK_LOCATION_INDEX = 0;
    public static final int SECTOR_LOCATION_INDEX = 1;
    public static final int CATALOG_TRACK = 0;
    public static final int VTOC_SECTOR = 3;
    public static final int TRACK_SECTOR_PAIRS = 122;
    private static final String[] filetypes = new String[]{"B"};
    private int usedSectors = 0;
    private static final int[] sectorTranslate = new int[]{0, 7, 14, 6, 13, 5, 12, 4, 11, 3, 10, 2, 9, 1, 8, 15};

    public NakedosFormatDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public static NakedosFormatDisk[] create(String filename, ImageOrder imageOrder) {
        NakedosFormatDisk disk = new NakedosFormatDisk(filename, imageOrder);
        disk.format();
        return new NakedosFormatDisk[]{disk};
    }

    @Override
    public String getFormat() {
        return this.textBundle.get("NakedOS");
    }

    @Override
    public List<FileEntry> getFiles() {
        int i;
        ArrayList<FileEntry> list = new ArrayList<FileEntry>();
        int totalUsed = 0;
        int[] fileSizes = new int[256];
        byte[] catalogSector1 = this.readSector(0, 3);
        byte[] catalogSector2 = this.readSector(0, 10);
        byte[] catalogSector3 = this.readSector(0, 2);
        for (i = 0; i < 48; ++i) {
            if (catalogSector1[i + 208] != -2 && catalogSector1[i + 208] != -1) {
                int n = AppleUtil.getUnsignedByte(catalogSector1[i + 208]);
                fileSizes[n] = fileSizes[n] + 1;
            }
            if (catalogSector1[i + 208] == -1) continue;
            ++totalUsed;
        }
        for (i = 0; i < 256; ++i) {
            if (catalogSector2[i] != -2 && catalogSector2[i] != -1) {
                int n = AppleUtil.getUnsignedByte(catalogSector2[i]);
                fileSizes[n] = fileSizes[n] + 1;
            }
            if (catalogSector3[i] != -2 && catalogSector3[i] != -1) {
                int n = AppleUtil.getUnsignedByte(catalogSector3[i]);
                fileSizes[n] = fileSizes[n] + 1;
            }
            if (catalogSector2[i] != -1) {
                ++totalUsed;
            }
            if (catalogSector3[i] == -1) continue;
            ++totalUsed;
        }
        for (i = 0; i < 256; ++i) {
            if (fileSizes[i] == 0) continue;
            list.add(new NakedosFileEntry(this, i, fileSizes[i]));
        }
        this.usedSectors = totalUsed;
        return list;
    }

    @Override
    public FileEntry createFile() throws DiskFullException {
        return new NakedosFileEntry(this, -2, 0);
    }

    @Override
    public boolean canCreateDirectories() {
        return false;
    }

    @Override
    public boolean canCreateFile() {
        return false;
    }

    @Override
    public int getFreeSpace() {
        return this.getFreeSectors() * 256;
    }

    public int getFreeSectors() {
        return this.getTotalSectors() - this.getUsedSectors();
    }

    @Override
    public int getUsedSpace() {
        return this.usedSectors * 256;
    }

    public int getUsedSectors() {
        return this.usedSectors;
    }

    public int getTotalSectors() {
        int tracks = this.getTracks();
        int sectors = this.getSectors();
        return tracks * sectors;
    }

    @Override
    public String getDiskName() {
        return "";
    }

    protected byte[] readVtoc() {
        return this.readSector(0, 3);
    }

    protected void writeVtoc(byte[] vtoc) {
        this.writeSector(0, 3, vtoc);
    }

    @Override
    public FormattedDisk.DiskUsage getDiskUsage() {
        return new WPDiskUsage();
    }

    public int getTracks() {
        return 35;
    }

    public int getSectors() {
        return 16;
    }

    @Override
    public int[] getBitmapDimensions() {
        int tracks = this.getTracks();
        int sectors = this.getSectors();
        return new int[]{tracks, sectors};
    }

    @Override
    public int getBitmapLength() {
        return this.getTotalSectors();
    }

    @Override
    public String[] getBitmapLabels() {
        return new String[]{this.textBundle.get("DosFormatDisk.Track"), this.textBundle.get("DosFormatDisk.Sector")};
    }

    @Override
    public List<FormattedDisk.DiskInformation> getDiskInformation() {
        this.getFiles();
        List<FormattedDisk.DiskInformation> list = super.getDiskInformation();
        return list;
    }

    @Override
    public List<FormattedDisk.FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FormattedDisk.FileColumnHeader> list = new ArrayList<FormattedDisk.FileColumnHeader>();
        switch (displayMode) {
            case 2: {
                list.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1));
                break;
            }
            case 3: {
                list.add(new FormattedDisk.FileColumnHeader(" ", 1, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.Type"), 1, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("Name"), 30, 1));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.SizeInSectors"), 3, 3));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DeletedQ"), 7, 2));
                list.add(new FormattedDisk.FileColumnHeader(this.textBundle.get("DosFormatDisk.TrackAndSectorList"), 7, 2));
                break;
            }
            default: {
                list.addAll(super.getFileColumnHeaders(displayMode));
            }
        }
        return list;
    }

    @Override
    public boolean supportsDeletedFiles() {
        return true;
    }

    @Override
    public boolean canReadFileData() {
        return true;
    }

    @Override
    public boolean canWriteFileData() {
        return false;
    }

    @Override
    public boolean canHaveDirectories() {
        return false;
    }

    @Override
    public boolean canDeleteFile() {
        return false;
    }

    @Override
    public byte[] getFileData(FileEntry fileEntry) {
        byte[] fileData1;
        int i;
        if (!(fileEntry instanceof NakedosFileEntry)) {
            throw new IllegalArgumentException(this.textBundle.get("DosFormatDisk.InvalidFileEntryError"));
        }
        int offset = 0;
        byte[] catalogSector1 = this.readSector(0, 3);
        byte[] catalogSector2 = this.readSector(0, 10);
        byte[] catalogSector3 = this.readSector(0, 2);
        NakedosFileEntry entry = (NakedosFileEntry)fileEntry;
        byte[] fileData = new byte[entry.getSize()];
        for (i = 0; i < 48; ++i) {
            if (AppleUtil.getUnsignedByte(catalogSector1[i + 208]) != entry.getFileNumber()) continue;
            fileData1 = this.readSector(i / 16, sectorTranslate[i % 16]);
            System.arraycopy(fileData1, 0, fileData, offset, fileData1.length);
            offset += fileData1.length;
        }
        for (i = 0; i < 256; ++i) {
            if (AppleUtil.getUnsignedByte(catalogSector2[i]) != entry.getFileNumber()) continue;
            fileData1 = this.readSector((i + 48) / 16, sectorTranslate[(i + 48) % 16]);
            System.arraycopy(fileData1, 0, fileData, offset, fileData1.length);
            offset += fileData1.length;
        }
        for (i = 0; i < 256; ++i) {
            if (AppleUtil.getUnsignedByte(catalogSector3[i]) != entry.getFileNumber()) continue;
            fileData1 = this.readSector((i + 48 + 256) / 16, sectorTranslate[(i + 48 + 256) % 16]);
            System.arraycopy(fileData1, 0, fileData, offset, fileData1.length);
            offset += fileData1.length;
        }
        return fileData;
    }

    @Override
    public void setFileData(FileEntry fileEntry, byte[] fileData) throws DiskFullException {
        this.setFileData((NakedosFileEntry)fileEntry, fileData);
    }

    protected void setFileData(NakedosFileEntry fileEntry, byte[] data) throws DiskFullException {
    }

    @Override
    public void format() {
        this.getImageOrder().format();
        this.format();
    }

    protected void format(int tracksPerDisk, int sectorsPerTrack) {
    }

    protected void checkRange(int track, int sector) {
        if (track > 50 || sector > 32) {
            throw new IllegalArgumentException(this.textBundle.format("DosFormatDisk.InvalidTrackAndSectorCombinationError", track, sector));
        }
    }

    @Override
    public int getLogicalDiskNumber() {
        return 0;
    }

    @Override
    public String getSuggestedFilename(String filename) {
        int len = Math.min(filename.length(), 2);
        return filename.toUpperCase().substring(0, len).trim();
    }

    @Override
    public String getSuggestedFiletype(String filename) {
        return "B";
    }

    @Override
    public String[] getFiletypes() {
        return filetypes;
    }

    @Override
    public boolean needsAddress(String filetype) {
        return "B".equals(filetype);
    }

    @Override
    public boolean supportsDiskMap() {
        return true;
    }

    @Override
    public void changeImageOrder(ImageOrder imageOrder) {
        AppleUtil.changeImageOrderByTrackAndSector(this.getImageOrder(), imageOrder);
        this.setImageOrder(imageOrder);
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws DiskFullException {
        throw new UnsupportedOperationException(this.textBundle.get("DirectoryCreationNotSupported"));
    }

    private class WPDiskUsage
    implements FormattedDisk.DiskUsage {
        private int[] location = null;

        private WPDiskUsage() {
        }

        @Override
        public boolean hasNext() {
            return this.location == null || this.location[0] < NakedosFormatDisk.this.getTracks() && this.location[1] < NakedosFormatDisk.this.getSectors();
        }

        @Override
        public void next() {
            if (this.location == null) {
                this.location = new int[2];
            } else {
                this.location[1] = this.location[1] + 1;
                if (this.location[1] >= NakedosFormatDisk.this.getSectors()) {
                    this.location[1] = 0;
                    this.location[0] = this.location[0] + 1;
                }
            }
        }

        @Override
        public boolean isFree() {
            if (this.location == null || this.location.length != 2) {
                throw new IllegalArgumentException(StorageBundle.getInstance().get("DosFormatDisk.InvalidDimensionError"));
            }
            return false;
        }

        @Override
        public boolean isUsed() {
            return !this.isFree();
        }
    }
}

